/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import ibm.nways.analysis.dpCommon.NotifyObject;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;

public class PollingObjectDefinition
implements Serializable {
    public static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    public static final int INTEGER = 1;
    public static final int GAUGE = 2;
    public static final int COUNTER = 3;
    public static final String INTEGER_STRING = adminRB.getString("s_Integer");
    public static final String COUNTER_STRING = adminRB.getString("s_Counter");
    public static final String GAUGE_STRING = adminRB.getString("s_Gauge");
    private String identifier;
    private int dataType;
    private String expression;
    private String units;
    private NotifyObject whenToNotify;

    public PollingObjectDefinition() {
    }

    public PollingObjectDefinition(String string, int n, String string2, String string3, NotifyObject notifyObject) {
        this.identifier = string;
        this.dataType = n;
        this.expression = string2;
        this.units = string3;
        this.whenToNotify = notifyObject;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getUnits() {
        return this.units;
    }

    public NotifyObject getNotifyObject() {
        return this.whenToNotify;
    }

    public void setNotifyObject(NotifyObject notifyObject) {
        this.whenToNotify = notifyObject;
    }

    public static Vector getDataTypes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(INTEGER_STRING);
        vector.addElement(COUNTER_STRING);
        vector.addElement(GAUGE_STRING);
        return vector;
    }

    public static int toInt(String string) {
        int n = 0;
        if (string.equals(INTEGER_STRING)) {
            n = 1;
        } else if (string.equals(COUNTER_STRING)) {
            n = 3;
        } else if (string.equals(GAUGE_STRING)) {
            n = 2;
        }
        return n;
    }

    public static String toString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = INTEGER_STRING;
                break;
            }
            case 3: {
                string = COUNTER_STRING;
                break;
            }
            case 2: {
                string = GAUGE_STRING;
                break;
            }
            default: {
                System.err.println("data type is Unknown\n");
            }
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Polling Object Definition:\n");
        stringBuffer.append(String.valueOf(this.getIdentifier()) + ", ");
        switch (this.getDataType()) {
            case 1: {
                stringBuffer.append("data type is Integer\n");
                break;
            }
            case 3: {
                stringBuffer.append("data type is Counter\n");
                break;
            }
            case 2: {
                stringBuffer.append("data type is Gauge\n");
                break;
            }
            default: {
                stringBuffer.append("data type is Unknown\n");
            }
        }
        stringBuffer.append(" Expression to evaluate is : " + this.expression + "\n");
        if (this.units != null) {
            stringBuffer.append("units : " + this.units);
        }
        if (this.whenToNotify != null) {
            stringBuffer.append(this.whenToNotify.toString());
        }
        return stringBuffer.toString();
    }
}

